import functools
def format(type):
    if type=='currency':
        def format(value):
            return("${:,.2f}".format(value))
    if type=='character':
        def format(value):
            return(value.capitalize())
    return format

def format_as_character(function):
    format_type=format('character')
    @functools.wraps(function)
    def format_result(*args, **kwargs):
        x = function(*args, **kwargs)
        return format_type(x)
    return format_result

def format_as_currency(function):
    format_type=format('currency')
    @functools.wraps(function)
    def format_result(*args, **kwargs):
        x = function(*args, **kwargs)
        return format_type(x)
    return format_result

